//
//  CRImageFilterResize.h
//  CRGraphics
//
//  Created by Yaroslav Glushchenko on 9/1/10.
//  Copyright 2010 Corner-A. All rights reserved.
//

#import "CRCIImageFilter.h"

extern NSString* const CRImageFilterResizeWidthKey;
extern NSString* const CRImageFilterResizeHeightKey;
extern NSString* const CRImageFilterResizeWantsBorderKey;
extern NSString* const CRImageFilterResizeBorderColorKey;

//////////////////////////////////////////////////////////////////////
// Resizes the image keeping original aspect ration
//////////////////////////////////////////////////////////////////////
@interface CRImageFilterResize : CRCIImageFilter
{
}

// Port wrappers
@property (nonatomic, assign)	CGFloat		width;
@property (nonatomic, assign)	CGFloat		height;
@property (nonatomic, assign)	BOOL		wantsBorder;
@property (nonatomic, copy)		NSColor*	borderColor;

@end